(function() {
  //MENU SINGLETON
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'collections/event/EventCollection', 'collections/timereport/TimereportCollection', 'collections/project/ProjectCollection', 'collections/todos/TodoCollection', 'collections/notifications/NotificationCollection', 'views/timereport/TimereportListView', 'views/event/EventListView', 'views/event/EventWeekView', 'views/monthreports/MonthreportsListView', 'views/contact/ContactListView', 'views/objectbrowser/ObjectFolderBrowserView', 'views/project/ProjectListView', 'views/password/ChangePasswordView', 'views/todo/TodoListView', 'views/notification/NotificationListView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, EventCollection, TimereportCollection, ProjectCollection, TodoCollection, NotificationCollection, TimereportListView, EventListView, EventWeekView, MonthreportsListView, ContactListView, ObjectFolderBrowserView, ProjectListView, ChangePasswordView, TodoListView, NotificationListView) {
    var MenuView;
    return MenuView = class MenuView extends Backbone.View {
      initialize(usr, obj) {
        this.usr = usr;
        this.obj = obj;
        //console.log 'MENU INIT'
        this.template = Handlebars.templates['MenuView'];
        this.eventsCol = new EventCollection();
        this.projectCol = new ProjectCollection();
        this.timereportsCol = new TimereportCollection();
        this.timereportsCol.on('change', this.__update_timereports_alert, this);
        this.timereportsCol.fetch();
        this.notCol = new NotificationCollection();
        return this.todosCol = new TodoCollection();
      }

      events() {
        return {
          'tap .btn-menu': 'menuClicked',
          'tap #id-btn-logout': 'btnLogoutClicked'
        };
      }

      render() {
        var texts;
        texts = new Object();
        texts.trs = "Time Reports";
        if (window.isCompany("rt1.tv")) {
          texts.trs = "Produktionsberichte";
        }
        this.$el.html(this.template({
          texts: texts,
          trND: this.timereportsCol.get_number_not_done_timereports(),
          pdf: this.__has_pdf_reports(),
          contacts: this.__show_contacts(),
          objBrowser: this.__show_object_browser(),
          projects: this.__show_projects(),
          password: this.__show_password(),
          todos: this.__show_todos(),
          timereports: this.__show_timereports(),
          notifications: this.__show_notifications()
        }));
        this.$el.attr('id', 'id-menu-panel');
        this.$el.attr('data-role', 'panel');
        this.$el.attr('data-display', 'overlay');
        this.$el.attr('data-position-fixed', 'true');
        this.$el.attr('data-swipe-close', 'true');
        return this.$el;
      }

      menuClicked(event) {
        var btn, id, view;
        //console.log 'MENU CLICKED'
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        if (id === "#divTimeReportContent") {
          return view = this.__get_view_from_stack('TimereportListView');
        } else if (id === '#divEventContent') {
          return view = this.__get_view_from_stack('EventListView');
        } else if (id === '#divEventWeekContent') {
          return view = this.__get_view_from_stack('EventWeekView');
        } else if (id === '#divMonthReportsContent') {
          return view = this.__get_view_from_stack('MonthreportsListView');
        } else if (id === '#divContactListViewContent') {
          return view = this.__get_view_from_stack('ContactListView');
        } else if (id === '#divObjectBrowserViewContent') {
          return view = this.__get_view_from_stack('ObjectFolderBrowserView');
        } else if (id === '#divProjectListViewContent') {
          return view = this.__get_view_from_stack('ProjectListView');
        } else if (id === '#divChangePasswordViewContent') {
          return view = this.__get_view_from_stack('ChangePasswordView');
        } else if (id === '#divTodoListViewContent') {
          return view = this.__get_view_from_stack('TodoListView');
        } else if (id === "#divNotificationListViewContent") {
          return view = this.__get_view_from_stack('NotificationListView');
        } else if (id === 'UpdateCollections') {
          btn.removeClass('btn-menu-refresh').addClass('btn-menu-refresh-clicked');
          return this.__refresh_current_view();
        }
      }

      //$.mobile.jqmNavigator.pushView(view,{ transition: "none"})
      btnLogoutClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return this.usr.disconnect().done(function(data, textStatus, jqXHR) {
          window.localStorage.clear();
          window.localStorage.setItem("oidcToken", "");
          return window.location.href = 'index.html';
        });
      }

      __get_view_from_stack(viewName) {
        var nextView;
        if (!EventListView) {
          EventListView = require("views/event/EventListView");
        }
        if (!EventWeekView) {
          EventListView = require("views/event/EventWeekView");
        }
        if (!TimereportListView) {
          TimereportListView = require("views/timereport/TimereportListView");
        }
        if (!MonthreportsListView) {
          MonthreportsListView = require("views/monthreports/MonthreportsListView");
        }
        if (!ContactListView) {
          ContactListView = require('views/contact/ContactListView');
        }
        if (!ObjectFolderBrowserView) {
          ObjectFolderBrowserView = require('views/objectbrowser/ObjectFolderBrowserView');
        }
        if (!ProjectListView) {
          ProjectListView = require('views/project/ProjectListView');
        }
        if (!ChangePasswordView) {
          ChangePasswordView = require('views/password/ChangePasswordView');
        }
        if (!TodoListView) {
          TodoListView = require('views/todo/TodoListView');
        }
        if (!NotificationListView) {
          NotificationListView = require('views/notification/NotificationListView');
        }
        nextView = _.find($.mobile.jqmNavigator.getViews(), function(view) {
          return $(view.el).attr('id') === 'id-' + viewName;
        });
        if (nextView) {
          if (nextView === this.__get_current_view()) {
            $('#id-menu-panel').panel('close');
          } else {
            //TODO EXTRA DURTY NEEDS IMPROVEMENT IF DIFFERENT LEVELS ARE CLICKED
            if ($.mobile.jqmNavigator.getViews().length > 1) {
              return $.mobile.jqmNavigator.popToFirst({
                transition: 'none'
              });
            } else {
              return $.mobile.jqmNavigator.replaceAll(nextView, {
                transition: 'none'
              });
            }
          }
        } else {
          if (viewName === 'EventListView') {
            this.eventsCol.get_day_events(this.usr, Moment(), this.obj);
            nextView = new EventListView(this.usr, this.eventsCol);
          }
          if (viewName === 'EventWeekView') {
            this.eventsCol.get_week_events(this.usr, Moment());
            nextView = new EventWeekView(this.usr, this.eventsCol);
          }
          if (viewName === 'TimereportListView') {
            nextView = new TimereportListView(this.usr, this.obj);
          }
          if (viewName === 'MonthreportsListView') {
            nextView = new MonthreportsListView(this.usr);
          }
          if (viewName === 'ContactListView') {
            nextView = new ContactListView(this.usr);
          }
          if (viewName === 'ObjectFolderBrowserView') {
            nextView = new ObjectFolderBrowserView(this.usr, 'EventsViewing');
          }
          if (viewName === 'ProjectListView') {
            this.projectCol.get_projects(this.usr);
            nextView = new ProjectListView(this.usr, this.projectCol, 'ProjectsViewing');
          }
          if (viewName === 'ChangePasswordView') {
            nextView = new ChangePasswordView(this.usr);
          }
          if (viewName === 'TodoListView') {
            this.todosCol.get_todos(this.usr);
            nextView = new TodoListView(this.usr, this.todosCol);
          }
          if (viewName === 'NotificationListView') {
            this.notCol.get_notifications(this.usr);
            nextView = new NotificationListView(this.usr, this.notCol);
          }
          return $.mobile.jqmNavigator.replaceAll(nextView, {
            transition: 'none'
          });
        }
      }

      btnPanelClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $('#id-menu-panel').panel('open');
      }

      __refresh_current_view() {
        var view;
        if (!EventListView) {
          EventListView = require("views/event/EventListView");
        }
        if (!EventWeekView) {
          EventListView = require("views/event/EventWeekView");
        }
        if (!TimereportListView) {
          TimereportListView = require("views/timereport/TimereportListView");
        }
        if (!ContactListView) {
          ContactListView = require('views/contact/ContactListView');
        }
        if (!ObjectFolderBrowserView) {
          ObjectFolderBrowserView = require('views/objectbrowser/ObjectFolderBrowserView');
        }
        if (!ProjectListView) {
          ProjectListView = require('views/project/ProjectListView');
        }
        if (!TodoListView) {
          TodoListView = require('views/todo/TodoListView');
        }
        if (!NotificationListView) {
          NotificationListView = require('views/notification/NotificationListView');
        }
        view = this.__get_current_view();
        if (view instanceof EventListView) {
          view.eventsCol.set_day_events(this.usr, view.dayToShow, view.obj);
        } else if (view instanceof EventWeekView) {
          view.eventsCol.get_week_events(this.usr, view.dayToShow);
        } else if (view instanceof TimereportListView) {
          view.__get_timereports('ND');
          view.__get_timereports('RC');
        } else if (view instanceof ContactListView) {
          view.contactsCol.get_contacts(this.usr);
        } else if (view instanceof ObjectFolderBrowserView) {
          view.objectsCol.get_simple_objects(this.usr);
        } else if (view instanceof ProjectListView) {
          view.projectCol.get_projects(this.usr);
        } else if (view instanceof TodoListView) {
          view.todosCol.get_todos(this.usr);
        } else if (view instanceof NotificationListView) {
          view.notCol.get_notifications(this.usr);
        }
        return $('#id-btn-menu-refresh').addClass('btn-menu-refresh').removeClass('btn-menu-refresh-active');
      }

      __get_current_view() {
        var N;
        N = $.mobile.jqmNavigator.getViews().length - 1;
        return $.mobile.jqmNavigator.getViews()[N];
      }

      __has_pdf_reports() {
        return this.usr.__enabled_pdf_reports();
      }

      __show_contacts() {
        return this.usr.__enabled_contacts();
      }

      __show_object_browser() {
        return this.usr.__enabled_object_browser();
      }

      __show_projects() {
        return this.usr.__enabled_projects();
      }

      __show_password() {
        return this.usr.__can_change_password();
      }

      __show_todos() {
        return this.usr.__enabled_todos();
      }

      __show_timereports() {
        return this.usr.__enabled_timereports();
      }

      __show_notifications() {
        return this.usr.__enabled_notifications();
      }

    };
  });

}).call(this);
